#include <stdio.h>
#include <mpi.h>
#include <unistd.h>

void work(int iter)
{
    sleep(iter);
}

int main(int argc, char **argv)
{
    int rank, nsecs, niter;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    MPI_Request req;

    if (rank == 0)
    {
        nsecs = 10;
        sleep(nsecs);

       	/* TRAVAIL A FAIRE
           Envoyer nsecs au processus 1
         */
	MPI_Send(&nsecs, 1, MPI_INTEGER, 1, 42, MPI_COMM_WORLD, &req);
	}
    else if (rank == 1)
    {
        niter = 0;
        /* TRAVAIL A FAIRE

           Tant qu'on n'a pas recu nsecs de P0 :
               
               niter++;
               work(niter);
           */
	int flag;
	MPI_Irecv(&req, 1, MPI_INTEGER, 0, 42, MPI_COMM_WORLD, &req);
	do
	{	
		niter++;
		work(niter);
		MPI_Test(&req, &flag, MPI_STATUS_IGNORE);
	} while (!flag);

        printf("Nsecs = %d s  / Nb iter = %d\n", nsecs, niter);
    }

    MPI_Finalize();
    return 0;
}

